/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.Validate;

public class Filter
implements Predicate<ItemStack> {
    public static final int FILTER_SIZE = 9;
    private final Flags flags;
    private final List<IItemMatcher> matchers = Lists.newArrayList();
    private final List<ItemStack> rawStacks = Lists.newArrayList();
    private final boolean matchAll;
    private final boolean roundRobin;
    private int rrCounter = 0;

    public Filter() {
        this.flags = Flags.DEFAULT_FLAGS;
        this.matchAll = false;
        this.roundRobin = false;
    }

    public Filter(ItemStack moduleStack, boolean storeRaw, boolean roundRobin) {
        this.roundRobin = roundRobin;
        int n = this.rrCounter = roundRobin ? ModuleHelper.getRoundRobinCounter(moduleStack) : 0;
        if (moduleStack.m_41720_() instanceof ModuleItem && moduleStack.m_41782_()) {
            this.flags = new Flags(moduleStack);
            this.matchAll = ModuleHelper.isMatchAll(moduleStack);
            BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack, null);
            for (int i = 0; i < filterHandler.getSlots(); ++i) {
                ItemStack filterStack = filterHandler.getStackInSlot(i);
                if (filterStack.m_41619_()) continue;
                IItemMatcher matcher = this.createMatcher(filterStack, moduleStack);
                this.matchers.add(matcher);
                if (!storeRaw) continue;
                this.rawStacks.add(filterStack);
            }
            if (roundRobin && this.rrCounter >= this.matchers.size()) {
                this.rrCounter = 0;
            }
        } else {
            this.flags = Flags.DEFAULT_FLAGS;
            this.matchAll = false;
        }
    }

    @Nonnull
    private IItemMatcher createMatcher(ItemStack filterStack, ItemStack moduleStack) {
        Item item = filterStack.m_41720_();
        if (item instanceof SmartFilterItem) {
            SmartFilterItem sf = (SmartFilterItem)item;
            return sf.compile(filterStack, moduleStack);
        }
        return ((ModuleItem)moduleStack.m_41720_()).getFilterItemMatcher(filterStack);
    }

    public List<ItemStack> getRawStacks() {
        return this.rawStacks;
    }

    public boolean isEmpty() {
        return this.matchers.isEmpty();
    }

    public boolean isBlacklist() {
        return this.flags.isBlacklist();
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.roundRobin && !this.matchers.isEmpty()) {
            return this.matchers.get(this.rrCounter).matchItem(stack, this.flags) != this.flags.isBlacklist();
        }
        for (IItemMatcher matcher : this.matchers) {
            boolean matchedOne = matcher.matchItem(stack, this.flags);
            if ((this.matchAll || !matchedOne) && (!this.matchAll || matchedOne)) continue;
            return this.matchAll == this.flags.isBlacklist();
        }
        return this.matchAll != this.flags.isBlacklist();
    }

    public Optional<Integer> cycleRoundRobin() {
        if (this.roundRobin && ++this.rrCounter >= this.matchers.size()) {
            this.rrCounter = 0;
        }
        return this.roundRobin ? Optional.of(this.rrCounter) : Optional.empty();
    }

    public boolean testFluid(Fluid fluid) {
        for (IItemMatcher matcher : this.matchers) {
            if (!matcher.matchFluid(fluid, this.flags)) continue;
            return !this.flags.isBlacklist();
        }
        return this.flags.isBlacklist();
    }

    public Flags getFlags() {
        return this.flags;
    }

    public static class Flags {
        public static final Flags DEFAULT_FLAGS = new Flags();
        private final boolean blacklist;
        private final boolean ignoreDamage;
        private final boolean ignoreNBT;
        private final boolean ignoreTags;

        public Flags(ItemStack moduleStack) {
            Validate.isTrue((boolean)(moduleStack.m_41720_() instanceof ModuleItem));
            this.blacklist = ModuleHelper.isBlacklist(moduleStack);
            this.ignoreDamage = ModuleHelper.ignoreDamage(moduleStack);
            this.ignoreNBT = ModuleHelper.ignoreNBT(moduleStack);
            this.ignoreTags = ModuleHelper.ignoreTags(moduleStack);
        }

        public Flags() {
            this.blacklist = ModuleItem.ModuleFlags.BLACKLIST.getDefaultValue();
            this.ignoreDamage = ModuleItem.ModuleFlags.IGNORE_DAMAGE.getDefaultValue();
            this.ignoreNBT = ModuleItem.ModuleFlags.IGNORE_NBT.getDefaultValue();
            this.ignoreTags = ModuleItem.ModuleFlags.IGNORE_TAGS.getDefaultValue();
        }

        public boolean isBlacklist() {
            return this.blacklist;
        }

        public boolean isIgnoreDamage() {
            return this.ignoreDamage;
        }

        public boolean isIgnoreNBT() {
            return this.ignoreNBT;
        }

        public boolean matchTags() {
            return !this.ignoreTags;
        }
    }
}

